
// CALCOLO ASCENSIONE RETTA E DECLINAZIONE PER L'EPOCA DESIDERATA 

function ascdec_mo()
	{  		
		// variabile giorno giuliano 1/1/2000 
		var jd_2000 = 2451545;
		// variabile giorno giuliano UT 
		var jd_now = JD_UT;
		
		// Formula del T Secoli 		
		
		var T = (jd_now - jd_2000)/36525;

	var R1 = Math.PI / 180; 
	var R2 = 180 / Math.PI;

	// le variabili nuove prese dallo starcat sono: 
	// astro_v_rad
	// astro_d_par 
	
	// conversione dati velocita' radiale da km/s a parsec / anno 
	var astro_v_rad_p = astro_v_rad / 977792; 
	
	// conversione moti propri 
	var astro_mp_mo_ra = astro_mps / 13751; 
	var astro_mp_mo_dec = astro_mpss / 206265; 
	
	var x_mo = astro_d_par * Math.cos(astro_dec * R1) * Math.cos(astro_ra * R1);
	var y_mo = astro_d_par * Math.cos(astro_dec * R1) * Math.sin(astro_ra * R1);
	var z_mo = astro_d_par * Math.sin(astro_dec * R1);
	
		
	var dx_mo = (x_mo / astro_d_par) * astro_v_rad_p - z_mo * astro_mp_mo_dec * Math.cos(astro_ra * R1) - y_mo * astro_mp_mo_ra;
	var dy_mo = (y_mo / astro_d_par) * astro_v_rad_p - z_mo * astro_mp_mo_dec * Math.sin(astro_ra * R1) + x_mo * astro_mp_mo_ra;
	var dz_mo = (z_mo / astro_d_par) * astro_v_rad_p + astro_d_par * astro_mp_mo_dec * Math.cos(astro_dec * R1);
	
	var T1 =  T * 100; 
	
	var x_mo_1 = x_mo + T1 * dx_mo;
	var y_mo_1 = y_mo + T1 * dy_mo;
	var z_mo_1 = z_mo + T1 * dz_mo;
	
	var ra_mo = Math.atan2(y_mo_1 , x_mo_1);
	
	var den_mo = Math.sqrt(Math.pow(x_mo_1,2) + Math.pow(y_mo_1,2));
	
	var dec_mo = Math.atan2(z_mo_1 , den_mo);
	
	ra_mo = ra_mo * R2 ; 
	
	dec_mo = dec_mo * R2 ; 	
		
		// ascensione retta dopo la correzione moti propri 
		var dra1 = 	ra_mo;
		 

		// declinazione dopo la correzione dei moti propri  
		var ddec1 = dec_mo;
		
		
		// parametri necessari per la formula seguente 
		var a = 2306.2181;
		var b = 0.30188;
		var c = 0.017998;
		var d = 1.09468;
		var e = 0.018203;
		var f = 2004.3109;
		var g = 0.42665;
		var h = 0.041833;
		
		var zeta = a * T + b * Math.pow(T,2) + c * Math.pow(T,3) ;
	 
		var z = a * T + d * Math.pow(T,2) + e * Math.pow(T,3) ;
		 
		var teta = f * T - g * Math.pow(T,2) - h * Math.pow(T,3)  ;
		
		zeta = zeta / 3600; 
		z = z / 3600; 
		teta = teta / 3600; 

		var A = Math.cos(ddec1*Math.PI/180)*Math.sin((dra1+zeta)*Math.PI/180);
		
		var B = Math.cos(teta*Math.PI/180)*Math.cos(ddec1*Math.PI/180)*Math.cos((dra1+zeta)*Math.PI/180)-Math.sin(teta*Math.PI/180)*Math.sin(ddec1*Math.PI/180);
		
		var C = Math.sin(teta*Math.PI/180)*Math.cos(ddec1*Math.PI/180)*Math.cos((dra1+zeta)*Math.PI/180)+Math.cos(teta*Math.PI/180)*Math.sin(ddec1*Math.PI/180) ;
		
		// ascensione retta dopo la correzione per la precessione 
		var dra2 = (Math.atan2(A,B)*180/Math.PI) + z;
		
		// condizione prevista da atan2 per mettere l'angolo negativo nel giusto quadrante
		if (dra2 < 0) {dra2 = dra2 + 360}
				
		// declinazione dopo la correzione per la precessione 
		var ddec2 = Math.asin(C)*180/Math.PI;
		

	  	// Formula L 
	  	var L = 280.4665+36000.7698*T+0.000303*Math.pow(T,2);
  		/*	
  		Ldec = L/360;
	  	Lint = Math.floor(Ldec); 
	  	L = (Ldec-Lint)*360;	
  		*/	
  		L = L*Math.PI/180;
	   
	  	// Formula L1 
	  	var L1 = 218.3164+481267.8812*T-0.001599*Math.pow(T,2);
  		/*	
  		L1dec = L1/360;
	  	L1int = Math.floor(L1dec); 
	  	L1 = (L1dec-L1int)*360;
  		*/	
  		L1 = L1*Math.PI/180;
	  
	  	//Formula M 
	  	var M = 357.5291+35999.0503*T-0.000154* Math.pow(T,2);
  		/*	
  		Mdec = M/360;
	  	Mint = Math.floor(Mdec); 
	  	M = (Mdec-Mint)*360;
  		*/	
  		M = M*Math.PI/180;
	  
	  	// Formula M1	
	  	var M1 = 134.9634+477198.8675*T+0.008721*Math.pow(T,2);
  		/*	
  		M1dec = M1/360;
	  	M1int = Math.floor(M1dec); 
	  	M1 = (M1dec-M1int)*360;
  		*/	
  		M1 = M1*Math.PI/180;
	  
	  	// Formula O 
	  	var O = 125.0443-1934.1363*T+0.002075*Math.pow(T,2);
  		/*	
  		Odec = O/360;
	  	Oint = Math.floor(Odec); 
	  	O = (Odec-Oint)*360;
  		*/	
  		O = O*Math.PI/180;
	  
	  	var DF = 	-(17.1996+0.01742*T)*Math.sin(O)
			  -(1.3187+0.00016*T)*Math.sin(2*L)
			  -0.2274*Math.sin(2*L1)
			  +0.2062*Math.sin(2*O)
			  +(0.1426-0.0004*T)*Math.sin(M)
			  +0.0712*Math.sin(M1)
			  -(0.0517-0.00012*T)*Math.sin(2*L+M)
			  -0.0386*Math.sin(2*L1-O)
			  -0.0301*Math.sin(2*L1+M1)
			  +0.0217*Math.sin(2*L-M)
			  -0.0158*Math.sin(2*L-2*L1+M1)
			  +0.0129*Math.sin(2*L-O)
			  +0.0123*Math.sin(2*L1-M1);
			  	  
	  	var DE = 	+(9.2025+0.00089*T)*Math.cos(O)
			  +(0.5736-0.00031*T)*Math.cos(2*L)
			  +0.0977*Math.cos(2*L1)
			  -0.0895*Math.cos(2*O)
			  +0.0224*Math.cos(2*L+M)
			  +0.0200*Math.cos(2*L1-O)
			  +0.0129*Math.cos(2*L1+M1)
			  -0.0095*Math.cos(2*L-M)
			  -0.0070*Math.cos(2*L-O);


		// Formula obliquità di Meeus
		// E0 = 23°26'21".448 - 46".8150*T - 0".00059T^2 +0".001813*T^3;
		var E0 = 23.4392911111 - 0.013004166666*T - 0.0000016388888*Math.pow(T,2) + 0.000000503611111*Math.pow(T,3);  
		var E10 = E0 + (DE/3600);
		
		
		if (E10 >= 360) 
			{
				var E11 = Math.floor(E10 / 360) * 360 ; 
				var E1 = E10 - E11;	
			}
						
		if (E10 <= -360)
			{
				var E11 = (Math.floor(E10 / 360)+1) * 360; 
				var E1 = (E10 - E11); 	
				if (E1 < 0) {E1 = E1 + 360}
			}
						
		if (E10 > -360 && E10 < 360)
			{
				if (E10 < 0) {var E1 = E10 + 360}
				var E1 = E10;	
			}




/*
	  // Formule di Berger
	    var E0 = 0;
		var E1 = berger()[0];

*/






			
		// conversione DF e DE in ore decimali 
		DF = DF / 3600;
		DE = DE / 3600;


		// Differenza in ascensione retta per la nutazione 
		var dra3 = (Math.cos(E1*Math.PI/180)+Math.sin(E1*Math.PI/180)*Math.sin(dra2*Math.PI/180)*Math.tan(ddec2*Math.PI/180))*DF - (Math.cos(dra2*Math.PI/180)*Math.tan(ddec2*Math.PI/180))*DE; 
		
		// Differenza in declinazione per la nutazione 
		var ddec3 = (Math.sin(E1*Math.PI/180)*Math.cos(dra2*Math.PI/180))*DF+Math.sin(dra2*Math.PI/180)*DE;  
		
		// longitudine media geometrica del sole 
		var LL = 280.46646 + 36000.76983 * T + 0.0003032 * Math.pow(T,2);
				
		// anomalia media geometrica del sole 
		var MM = 357.52911 + 35999.05029 * T - 0.0001537 * Math.pow(T,2);  
		
		// eccentricità dell'orbita terrestre 
		var ECC = 0.016708634 - 0.000042037 * T - 0.0000001267 * Math.pow(T,2);
		
		// equazione del centro del sole 
		var CC = (1.914602 - 0.004817 * T - 0.000014 * Math.pow(T,2))* Math.sin(MM*Math.PI/180)+(0.019993 - 0.000101 * T)* Math.sin((2*MM)*Math.PI/180)+0.000289 * Math.sin((3*MM)*Math.PI/180);
		
		// longitudine vera del sole 
		var LV = LL + CC;
		
		// longitudine del perielio 
		var PP = 102.93735 + 1.71946 * T + 0.00046 * Math.pow(T,2);
		
		var a2 = 20.49552 /3600 ; 
		
		
		// Differenza in ascensione retta per l'aberrazione annua della luce 
		var dra4 =  -a2 * ((Math.cos(dra2*Math.PI/180)*Math.cos(LV*Math.PI/180)*Math.cos(E1*Math.PI/180)+Math.sin(dra2*Math.PI/180)*Math.sin(LV*Math.PI/180))/Math.cos(ddec2*Math.PI/180))+ ECC * a2 *((Math.cos(dra2*Math.PI/180)*Math.cos(PP*Math.PI/180)*Math.cos(E1*Math.PI/180)+Math.sin(dra2*Math.PI/180)*Math.sin(PP*Math.PI/180))/Math.cos(ddec2*Math.PI/180));  
		
		
		// Differenza in declinazione per l'aberrazione annua della luce 
		var ddec4 =  -a2 * (  (Math.cos(LV*Math.PI/180)*Math.cos(E1*Math.PI/180)*(Math.tan(E1*Math.PI/180)*Math.cos(ddec2*Math.PI/180)-Math.sin(dra2*Math.PI/180)*Math.sin(ddec2*Math.PI/180))+Math.cos(dra2*Math.PI/180)*Math.sin(ddec2*Math.PI/180)*Math.sin(LV*Math.PI/180)))+ ECC * a2 * (  (Math.cos(PP*Math.PI/180)*Math.cos(E1*Math.PI/180)*(Math.tan(E1*Math.PI/180)*Math.cos(ddec2*Math.PI/180)-Math.sin(dra2*Math.PI/180)*Math.sin(ddec2*Math.PI/180))+Math.cos(dra2*Math.PI/180)*Math.sin(ddec2*Math.PI/180)*Math.sin(PP*Math.PI/180)));
		
				
		
		
		
		// ascensione retta in gradi sessagesimali decimali 
		var AR_G_DEC = dra2 + dra3 + dra4;
		
		// ascensione retta in ore decimali 
		var AR_ORE_DEC  = AR_G_DEC / 15;
		
		// Conversione ascensione retta in ore, minuti e secondi 	
		var AR_ORE = Math.floor(AR_ORE_DEC); 
		var AR_MIN_DEC = (AR_ORE_DEC - AR_ORE) * 60; 
		var AR_MIN = Math.floor(AR_MIN_DEC); 
		var AR_SEC_DEC = (AR_MIN_DEC - AR_MIN) * 60; 
		
		// condizione per valori negativi 
		if (AR_ORE < 0) 
			{
				AR_ORE = AR_ORE + 24;		
			}





		// declinazione in gradi decimali 
		var DEC_G_DEC = ddec2 + ddec3 + ddec4; 
		
		// Conversione declinazione in gradi primi e secondi
  		var DEC_GRADI = Math.floor(DEC_G_DEC);		
		var DEC_PRIMI_DEC = (DEC_G_DEC - DEC_GRADI) * 60;
		var DEC_PRIMI = Math.floor(DEC_PRIMI_DEC); 
		var DEC_SECONDI_DEC = (DEC_PRIMI_DEC - DEC_PRIMI) * 60;	
		var SGN = "+ ";
		
		// condizione per valori negativi 
		if (DEC_G_DEC < 0) 
			{
				var DEC_G_DEC_ABS = Math.abs(DEC_G_DEC);
				var DEC_GRADI = Math.floor(DEC_G_DEC_ABS);
				var DEC_PRIMI_DEC = (DEC_G_DEC_ABS - DEC_GRADI) * 60;
				var DEC_PRIMI = Math.floor(DEC_PRIMI_DEC); 
				var DEC_SECONDI_DEC = (DEC_PRIMI_DEC - DEC_PRIMI) * 60;	
				var SGN = "- ";	
			}
	
		// Riconversione dei dati L L1 M M1 O in gradi non radianti 
		L = L *180/Math.PI;
		L1 = L1*180/Math.PI;
		M = M*180/Math.PI;
		M1 = M1*180/Math.PI;
		O = O*180/Math.PI;
		
		
		
		
		
		
		return [jd_now,astro_ra,astro_dec,astro_mpra,astro_mpdec,T,dra1,ddec1,zeta,z,teta,A,B,C,dra2,ddec2,L,L1,M,M1,O,DF,DE,E1,dra3,ddec3,LL,MM,CC,LV,dra4,ddec4,AR_G_DEC,DEC_G_DEC,AR_ORE,AR_MIN,AR_SEC_DEC,DEC_GRADI,DEC_PRIMI,DEC_SECONDI_DEC,SGN];
	
	}
  